//
//  Material.vsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//

#ifdef OGL_ES2 
#	ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#	else
precision mediump float;
#	endif 
#	define prec_high highp
#	define prec_med mediump
#	define prec_low lowp 
#else  
#	define prec_high
#	define prec_med 
#	define prec_low  
#endif

uniform prec_med float u_renderTime;
uniform prec_med vec3 u_frustumPlanes;
uniform prec_high mat4 u_modelViewMatrix;
uniform prec_high mat4 u_modelViewProjectionMatrix;
 
attribute prec_high vec4 a_position;

varying prec_med vec3 v_eyeSpace_viewRay;
varying prec_med vec3 v_eyeSpace_light_xyz;
varying prec_high vec2 v_gBuffer_coord;

void main()
{ 
	gl_Position = a_position;
  
	// calculate view raw to convert depth value to eye-space position
	v_eyeSpace_viewRay = u_frustumPlanes * a_position.xyz;
	
	// get the screen coords into range [0,1]
	v_gBuffer_coord = (a_position.xy + 1.0) * 0.5; 	
	
	float sinTime = sin(u_renderTime);
	float cosTime = cos(u_renderTime);
	vec3 light_pos = vec3(450.0 + sinTime * 250.0, 2091.0 + cosTime * 150.0, 100.0);
	
	// convert light pos to world space
	v_eyeSpace_light_xyz = (u_modelViewMatrix * vec4(light_pos, 1.0)).xyz;
}

